/*==========================================================================
  PALETTE.C

  Example code to initialize the palette for 8 bpp modes. The palette is
  initialized as follows:

  Entries       Color
  ----------    -------------
  0             black
  1             blue
  2             green
  3             cyan
  4             red
  5             magenta
  6             brown
  7             light gray
  8             gray
  9             light blue
  10            light green
  11            light cyan
  12            light red
  13            light magenta
  14            yellow
  15            white
  16 - 31       blue
  32 - 47       green
  48 - 63       cyan
  64 - 79       red
  80 - 95       magenta
  96 - 111      brown
  112 - 127     light gray
  128 - 143     gray
  144 - 159     light blue
  160 - 175     light green
  176 - 191     light cyan
  192 - 207     light red
  208 - 223     light magenta
  224 - 239     yellow
  240 - 255     white

  The DAC is normally set to the default 6 bit configuration on powerup which
  requires DAC values to be shifted to the left by 2 bits (each red, green,
  and blue color component is 6 bits).

  Copyright (c) 1994-1995 ATI Technologies Inc. All rights reserved
 =========================================================================*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <dos.h>
#include "..\util\atim64.h"
#include "..\util\sample.h"

#define INSTANCE 0

int main (void)
{
    int index, x, y, boxwidth, boxheight;

    // check if Mach64 adapter is installed
    if (detect_mach64 (INSTANCE) != YES_MACH64)
    {
        printf ("mach64 based adapter was not found.\n");
        return (1);
    }

    // fill global query structure by calling Mach 64 ROM
    if (query_hardware () != NO_ERROR)
    {
        printf ("Failed ROM call to query mach64 hardware.\n");
        return (1);
    }

    // set an accelerator mode - the palette is initializated in this
    // routine - see PALETTE.C in the UTIL directory
    if (open_mode (MODE_640x480, PITCH_XRES, COLOR_DEPTH_8) != NO_ERROR)
    {
        printf ("Error in setting display mode.\n");
        return (1);
    }

    // this example is only relevant for 8 bpp modes
    if (modeinfo.bpp != 8)
    {
        close_mode ();
        printf ("This example is designed for 8 bpp modes.\n");
        return (1);
    }

    // setup engine to default context
    init_engine ();

    // clear screen
    clear_screen (0, 0, modeinfo.xres, modeinfo.yres);

    // determine box size for each palette entry (256 total entries)
    boxwidth = modeinfo.xres / 16;
    boxheight = modeinfo.yres / 16;

    // draw filled rectangles showing the palette colors
    index = 0;
    x = 0;
    y = 0;
    for (index = 0; index < 256; index++)
    {
        // set fill color
        set_fg_color (index);

        // draw filled rectangle
        draw_rectangle (x, y, boxwidth - 1, boxheight - 1);

        x = x + boxwidth;
        if (x >= modeinfo.xres)
        {
            x = 0;
            y = y + boxheight;
        }
    }

    // wait for a carriage return
    getch ();

    // disable accelerator mode and switch back to VGA text mode
    close_mode ();

    return (0);
}

