; ===========================================================================
; ROMCAL0C.ASM
;
; Mach64 ROM interface function 0Ch - Set DPMS service mode.
;
; Compiling:
;   masm /Ml /D<memory model> romcalls.asm;
;       <memory model> = mem_S for SMALL model,
;                        mem_M for MEDIUM model,
;                        mem_L for LARGE model
;
; Copyright (c) 1993-94 ATI Technologies Inc. All rights reserved
; ===========================================================================

include ..\inc\atim64.inc

IFDEF mem_S
PARM        equ     4   ; passed parameters start at bp+4 for small model
ELSE
PARM        equ     6   ; passed parameters start at bp+6 for other models
ENDIF

IFDEF mem_S
.MODEL  SMALL, C
ELSEIFDEF mem_M
.MODEL  MEDIUM, C
ELSE
.MODEL  LARGE, C
ENDIF

.DATA

rom_addr    dw      64h
            dw      0c000h
            db      0

.CODE
.286

; Macro for 'call' model handling
Mcall       macro   routine
IFDEF mem_S
            call    NEAR PTR routine
ELSE
            call    FAR PTR routine
ENDIF
	        endm

; Externals
IFDEF mem_S
extrn   pgl_getrombase:NEAR
ELSE
extrn   pgl_getrombase:FAR
ENDIF

; ---------------------------------------------------------------------------
; ROM_SETDPMSCONTROL - ROM function 0ch
;
; Set display control based on input value. Input parameters are fetched from
; the stack. See PGL.H for symbolic values.
;
; Inputs : WORD DPMS service
;            0 - active
;            1 - stand-by
;            2 - suspend
;            3 - off
;
; Outputs: Return codes
;            0 - no error
;            1 - function complete with error
;            2 - function not supported
; ---------------------------------------------------------------------------
            public  ROM_setdpmscontrol

IFDEF mem_S
ROM_setdpmscontrol proc near
ELSE
ROM_setdpmscontrol proc far
ENDIF
            ; create frame pointer
            push    bp
            mov     bp, sp

            ; save registers used
            push    cx

            ; setup parameters for call to ATI rom
            Mcall   pgl_getrombase              ; get rom segment in ax
            mov     rom_addr+2, ax
            mov     ax, WORD PTR [bp+PARM]      ; get dpms service code
            and     ax, 3
            mov     cl, al

            ; setup ROM call
            mov     ax, 0ch                     ; function 0ch
            mov     rom_addr, 64h
            call    DWORD PTR rom_addr          ; call ROM using FAR CALL

            ; setup error code in AL
            mov     al, ah
            xor     ah, ah

            ; restore saved registers
            pop     cx

            ; remove frame pointer
            mov     sp, bp
            pop     bp

            ret

ROM_setdpmscontrol endp

            end

