/******************************************************************************
 * vint.c - Chapter 7 SBUFI sample code                                       *
 *                                                                            *
 * mach64 functions to handle mach64 CRTC vertical interrupts.                *
 *                                                                            *
 * Copyright (c) 1994-1998 ATI Technologies Inc.  All rights reserved.        *
 ******************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include "..\util\atim64.h"
#include "..\util\defines.h"
#include "..\util\main.h"


/******************************************************************************
 * set_vline                                                                  *
 *  Function: sets the CRTC vertical line                                     *
 *    Inputs: v_line - vertical line at which the interrupt is triggered      *
 *   Outputs: NONE                                                            *
 ******************************************************************************/

void set_vline (short v_line)
{
    iow16 (CRTC_VLINE, v_line);

    return;

} // set_vline


/******************************************************************************
 * enable_vline_int                                                           *
 *  Function: Enables the vertical line interrupt                             *
 *    Inputs: NONE                                                            *
 *   Outputs: NONE                                                            *
 ******************************************************************************/

void enable_vline_int (void)
{
    iow8 (CRTC_INT_CNTL, ior8 (CRTC_INT_CNTL) | 0x08);

    return;

} // enable_vline_int


/******************************************************************************
 * disable_vline_int                                                          *
 *  Function: disables the vertical line interrupt                            *
 *    Inputs: NONE                                                            *
 *   Outputs: NONE                                                            *
 ******************************************************************************/

void disable_vline_int (void)
{
    iow8 (CRTC_INT_CNTL, ior8 (CRTC_INT_CNTL) & 0xF7);

    return;

} // disable_vline_int
