/*==========================================================================
* FNT8x14.C - Copyright (c) 1993-94 ATI Technologies Inc. All rights reserved*
*                                                                          *
* PGL function that returns a pointer to the 8x14 interal PGL font.        *
* ======================================================================== */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>

#include "..\inc\pgl.h"
#include "..\inc\pglglob.h"

//
// Bitmap data array for 8x14 font
//
//   Width in pixels     : 8
//   Height in pixels    : 14
//   Bytes per character : 14
//   Total size in bytes : 3584
//
unsigned char pgl_fontbitmap8x14[] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x7e, 0x81, 0xa5, 0x81, 0x81, 0xbd, 0x99, 0x81, 
    0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xff, 
    0xdb, 0xff, 0xff, 0xc3, 0xe7, 0xff, 0x7e, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0xee, 0xfe, 
    0xfe, 0xfe, 0x7c, 0x38, 0x10, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x10, 0x38, 0x7c, 0xfe, 0x7c, 
    0x38, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x10, 0x38, 0x10, 0x6c, 0xee, 0x6c, 0x10, 
    0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 
    0x7c, 0x7c, 0xfe, 0xfe, 0x6c, 0x10, 0x38, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 
    0x3c, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe7, 0xc3, 0xc3, 
    0xe7, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 
    0x00, 0x00, 0x18, 0x3c, 0x66, 0x66, 0x3c, 0x18, 
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 
    0xe7, 0xc3, 0x99, 0x99, 0xc3, 0xe7, 0xff, 0xff, 
    0xff, 0xff, 0x00, 0x00, 0x1e, 0x0e, 0x1e, 0x36, 
    0x78, 0xcc, 0xcc, 0xcc, 0x78, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x3c, 0x18, 
    0x7e, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x1e, 0x1a, 0x1e, 0x18, 0x18, 0x18, 0x78, 0xf8, 
    0x70, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x36, 0x3e, 
    0x36, 0x36, 0x76, 0xf6, 0x66, 0x0e, 0x1e, 0x0c, 
    0x00, 0x00, 0x00, 0x18, 0xdb, 0x7e, 0x3c, 0x66, 
    0x66, 0x3c, 0x7e, 0xdb, 0x18, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x80, 0xe0, 0xf0, 0xfc, 0xfe, 0xfc, 
    0xf0, 0xe0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x02, 0x0e, 0x3e, 0x7e, 0xfe, 0x7e, 0x3e, 0x0e, 
    0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x3c, 
    0x7e, 0x18, 0x18, 0x18, 0x7e, 0x3c, 0x18, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 
    0x66, 0x66, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x7f, 0xdb, 0xdb, 0xdb, 0x7b, 0x1b, 
    0x1b, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x7c, 
    0xc6, 0xc6, 0x60, 0x7c, 0xf6, 0xde, 0x7c, 0x0c, 
    0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xfe, 0xfe, 0xfe, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x18, 0x3c, 0x7e, 0x18, 
    0x18, 0x7e, 0x3c, 0x18, 0x7e, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x18, 0x3c, 0x7e, 0x18, 0x18, 0x18, 
    0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x7e, 0x3c, 
    0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x0c, 0x0e, 0xff, 0x0e, 0x0c, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x70, 
    0xfe, 0x70, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0xc0, 
    0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x24, 0x66, 0xff, 0x66, 0x24, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 
    0x38, 0x38, 0x7c, 0x7c, 0xfe, 0xfe, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xfe, 0xfe, 0x7c, 0x7c, 
    0x7c, 0x38, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x18, 0x3c, 0x3c, 0x3c, 0x18, 0x18, 
    0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x36, 
    0x36, 0x36, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x6c, 
    0x6c, 0xfe, 0x6c, 0x6c, 0xfe, 0x6c, 0x6c, 0x00, 
    0x00, 0x00, 0x00, 0x18, 0x18, 0x7c, 0xc6, 0xc0, 
    0x78, 0x3c, 0x06, 0xc6, 0x7c, 0x18, 0x18, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x62, 0x66, 0x0c, 0x18, 
    0x30, 0x66, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x38, 0x6c, 0x38, 0x38, 0x76, 0xf6, 0xce, 0xcc, 
    0x76, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x0c, 
    0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x0c, 0x18, 0x30, 0x30, 
    0x30, 0x30, 0x30, 0x18, 0x0c, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x30, 0x18, 0x0c, 0x0c, 0x0c, 0x0c, 
    0x0c, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x6c, 0x38, 0xfe, 0x38, 0x6c, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x18, 0x18, 0x7e, 0x18, 0x18, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x0c, 0x0c, 0x0c, 0x18, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 
    0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 
    0x06, 0x0c, 0x18, 0x30, 0x60, 0xc0, 0x80, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xce, 0xde, 
    0xf6, 0xe6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x18, 0x78, 0x18, 0x18, 0x18, 0x18, 
    0x18, 0x18, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x7c, 0xc6, 0xc6, 0x0c, 0x18, 0x30, 0x60, 0xc6, 
    0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 
    0x06, 0x06, 0x3c, 0x06, 0x06, 0xc6, 0x7c, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x0c, 0x1c, 0x3c, 0x6c, 
    0xcc, 0xfe, 0x0c, 0x0c, 0x0c, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0xfe, 0xc0, 0xc0, 0xc0, 0xfc, 0x06, 
    0x06, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x7c, 0xc6, 0xc0, 0xc0, 0xfc, 0xc6, 0xc6, 0xc6, 
    0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xc6, 
    0x0c, 0x18, 0x30, 0x30, 0x30, 0x30, 0x30, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 
    0x7c, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 
    0x06, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x0c, 0x0c, 0x00, 0x00, 0x0c, 0x0c, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x0c, 0x0c, 0x00, 0x00, 0x0c, 0x0c, 0x0c, 0x18, 
    0x00, 0x00, 0x00, 0x00, 0x0c, 0x18, 0x30, 0x60, 
    0xc0, 0x60, 0x30, 0x18, 0x0c, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0xfe, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x60, 0x30, 0x18, 0x0c, 0x06, 0x0c, 0x18, 0x30, 
    0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 
    0xc6, 0x0c, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xde, 
    0xde, 0xde, 0xdc, 0xc0, 0x7e, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x38, 0x6c, 0xc6, 0xc6, 0xc6, 0xfe, 
    0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0xfc, 0x66, 0x66, 0x66, 0x7c, 0x66, 0x66, 0x66, 
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x66, 
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x66, 0x3c, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xf8, 0x6c, 0x66, 0x66, 
    0x66, 0x66, 0x66, 0x6c, 0xf8, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0xfe, 0x66, 0x60, 0x60, 0x7c, 0x60, 
    0x60, 0x66, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0xfe, 0x66, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x60, 
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 
    0xc6, 0xc0, 0xc0, 0xce, 0xc6, 0xc6, 0x7c, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 
    0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 
    0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0xd8, 0xd8, 
    0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xcc, 
    0xd8, 0xf0, 0xf0, 0xd8, 0xcc, 0xc6, 0xc6, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xf0, 0x60, 0x60, 0x60, 
    0x60, 0x60, 0x62, 0x66, 0xfe, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0xc6, 0xc6, 0xee, 0xfe, 0xd6, 0xd6, 
    0xd6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0xc6, 0xc6, 0xe6, 0xe6, 0xf6, 0xde, 0xce, 0xce, 
    0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 
    0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xfc, 0x66, 0x66, 0x66, 
    0x7c, 0x60, 0x60, 0x60, 0xf0, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 
    0xc6, 0xd6, 0x7c, 0x06, 0x00, 0x00, 0x00, 0x00, 
    0xfc, 0x66, 0x66, 0x66, 0x7c, 0x78, 0x6c, 0x66, 
    0xe6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 
    0xc0, 0x60, 0x38, 0x0c, 0x06, 0xc6, 0x7c, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x7e, 0x5a, 0x18, 0x18, 
    0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 
    0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x6c, 0x38, 
    0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 
    0xd6, 0xd6, 0xd6, 0xfe, 0xee, 0xc6, 0xc6, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0x6c, 0x38, 
    0x38, 0x38, 0x6c, 0xc6, 0xc6, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x18, 
    0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0xfe, 0xc6, 0x8c, 0x18, 0x30, 0x60, 0xc2, 0xc6, 
    0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x60, 
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xc0, 0x60, 
    0x30, 0x18, 0x0c, 0x06, 0x02, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x7c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 
    0x0c, 0x0c, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x10, 
    0x38, 0x6c, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0xff, 0x00, 0x18, 0x18, 0x18, 0x0c, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x0c, 0x7c, 
    0xcc, 0xdc, 0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0xe0, 0x60, 0x60, 0x7c, 0x66, 0x66, 0x66, 0x66, 
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x7c, 0xc6, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x1c, 0x0c, 0x0c, 0x7c, 
    0xcc, 0xcc, 0xcc, 0xcc, 0x7e, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xfe, 
    0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x1c, 0x36, 0x30, 0x30, 0xfc, 0x30, 0x30, 0x30, 
    0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x76, 0xce, 0xc6, 0xc6, 0x7e, 0x06, 0xc6, 
    0x7c, 0x00, 0x00, 0x00, 0xe0, 0x60, 0x60, 0x6c, 
    0x76, 0x66, 0x66, 0x66, 0xe6, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x18, 0x18, 0x00, 0x38, 0x18, 0x18, 
    0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x0c, 0x0c, 0x00, 0x1c, 0x0c, 0x0c, 0x0c, 0x0c, 
    0xcc, 0xcc, 0x78, 0x00, 0x00, 0x00, 0xe0, 0x60, 
    0x60, 0x66, 0x6c, 0x78, 0x6c, 0x66, 0xe6, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x38, 0x18, 0x18, 0x18, 
    0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0xfe, 0xd6, 
    0xd6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xdc, 0x66, 0x66, 0x66, 0x66, 
    0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 
    0x66, 0x66, 0x66, 0x7c, 0x60, 0x60, 0xf0, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xcc, 0xcc, 
    0xcc, 0x7c, 0x0c, 0x0c, 0x1e, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xdc, 0x66, 0x60, 0x60, 0x60, 
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x7c, 0xc6, 0x70, 0x1c, 0xc6, 0x7c, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x30, 0xfc, 
    0x30, 0x30, 0x30, 0x36, 0x1c, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0xcc, 0xcc, 0xcc, 
    0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0x6c, 0x38, 
    0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0xc6, 0xc6, 0xd6, 0xd6, 0xfe, 0x6c, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 
    0x6c, 0x38, 0x38, 0x6c, 0xc6, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 
    0xce, 0x76, 0x06, 0xc6, 0x7c, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xfe, 0x8c, 0x18, 0x30, 0x62, 
    0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x18, 
    0x18, 0x18, 0x70, 0x18, 0x18, 0x18, 0x0e, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 
    0x00, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x70, 0x18, 0x18, 0x18, 0x0e, 0x18, 
    0x18, 0x18, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x76, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x10, 0x38, 0x38, 0x6c, 0x6c, 0xfe, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x3c, 0x66, 0xc0, 0xc0, 
    0xc0, 0xc6, 0x66, 0x3c, 0x18, 0xcc, 0x38, 0x00, 
    0x00, 0x00, 0xc6, 0xc6, 0x00, 0xc6, 0xc6, 0xc6, 
    0xc6, 0xce, 0x76, 0x00, 0x00, 0x00, 0x00, 0x0c, 
    0x18, 0x30, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0xc6, 
    0x7c, 0x00, 0x00, 0x00, 0x00, 0x30, 0x78, 0xcc, 
    0x00, 0x78, 0x0c, 0x7c, 0xcc, 0xdc, 0x76, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xcc, 0xcc, 0x00, 0x78, 
    0x0c, 0x7c, 0xcc, 0xdc, 0x76, 0x00, 0x00, 0x00, 
    0x00, 0x60, 0x30, 0x18, 0x00, 0x78, 0x0c, 0x7c, 
    0xcc, 0xdc, 0x76, 0x00, 0x00, 0x00, 0x00, 0x38, 
    0x6c, 0x38, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0xdc, 
    0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x7c, 0xc6, 0xc0, 0xc0, 0xc6, 0x7c, 0x18, 0x6c, 
    0x38, 0x00, 0x00, 0x30, 0x78, 0xcc, 0x00, 0x7c, 
    0xc6, 0xfe, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0xcc, 0xcc, 0x00, 0x7c, 0xc6, 0xfe, 
    0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x30, 
    0x18, 0x0c, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0xc6, 
    0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 
    0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 
    0x00, 0x00, 0x00, 0x18, 0x3c, 0x66, 0x00, 0x38, 
    0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 
    0x00, 0x60, 0x30, 0x18, 0x00, 0x38, 0x18, 0x18, 
    0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x6c, 0x00, 
    0x38, 0x6c, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 
    0xc6, 0x00, 0x00, 0x00, 0x38, 0x6c, 0x38, 0x6c, 
    0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0x00, 
    0x00, 0x00, 0x1c, 0x30, 0xfe, 0x60, 0x60, 0x60, 
    0x7c, 0x60, 0x60, 0x60, 0xfe, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x66, 0xdb, 0x1b, 0x7f, 
    0xd8, 0xdf, 0x76, 0x00, 0x00, 0x00, 0x00, 0x7e, 
    0xd8, 0xd8, 0xd8, 0xd8, 0xfe, 0xd8, 0xd8, 0xd8, 
    0xde, 0x00, 0x00, 0x00, 0x00, 0x30, 0x78, 0xcc, 
    0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0x00, 0x7c, 
    0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 
    0x00, 0x30, 0x18, 0x0c, 0x00, 0x7c, 0xc6, 0xc6, 
    0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x30, 
    0x78, 0xcc, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xce, 
    0x76, 0x00, 0x00, 0x00, 0x00, 0x60, 0x30, 0x18, 
    0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xce, 0x76, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0x00, 0xc6, 
    0xc6, 0xc6, 0xce, 0x76, 0x06, 0xc6, 0x7c, 0x00, 
    0x6c, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 
    0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x6c, 0x00, 
    0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 
    0x7c, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x3c, 
    0x66, 0x60, 0x60, 0x66, 0x3c, 0x18, 0x18, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x38, 0x6c, 0x60, 0x60, 
    0xf0, 0x60, 0x66, 0xf6, 0x6c, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x66, 0x66, 0x3c, 0x18, 0x7e, 0x18, 
    0x3c, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0xfc, 
    0xc6, 0xfc, 0xc0, 0xcc, 0xde, 0xcc, 0xcc, 0xcc, 
    0xc6, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x1b, 0x18, 
    0x18, 0x18, 0x7e, 0x18, 0x18, 0x18, 0x18, 0xd8, 
    0x70, 0x00, 0x00, 0x0c, 0x18, 0x30, 0x00, 0x78, 
    0x0c, 0x7c, 0xcc, 0xdc, 0x76, 0x00, 0x00, 0x00, 
    0x00, 0x0c, 0x18, 0x30, 0x00, 0x38, 0x18, 0x18, 
    0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x0c, 
    0x18, 0x30, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 
    0x7c, 0x00, 0x00, 0x00, 0x00, 0x18, 0x30, 0x60, 
    0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0xdc, 0x76, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x76, 0xdc, 0x00, 0xbc, 
    0x66, 0x66, 0x66, 0x66, 0xe6, 0x00, 0x00, 0x00, 
    0x76, 0xdc, 0x00, 0xc6, 0xe6, 0xe6, 0xf6, 0xde, 
    0xce, 0xce, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x3c, 
    0x6c, 0x6c, 0x3e, 0x00, 0x7e, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x6c, 0x6c, 
    0x38, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x30, 
    0x30, 0x60, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x60, 
    0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x7e, 0x06, 0x06, 0x06, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x62, 0x66, 
    0x6c, 0x18, 0x30, 0x60, 0xdc, 0x36, 0x0c, 0x18, 
    0x3e, 0x00, 0x00, 0x60, 0x62, 0x66, 0x6c, 0x18, 
    0x36, 0x6e, 0xde, 0x36, 0x7e, 0x06, 0x06, 0x00, 
    0x00, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x3c, 
    0x3c, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x36, 0x6c, 0xd8, 0x6c, 0x36, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0xd8, 0x6c, 0x36, 0x6c, 0xd8, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x11, 0x44, 0x11, 0x44, 0x11, 0x44, 
    0x11, 0x44, 0x11, 0x44, 0x11, 0x44, 0x11, 0x44, 
    0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 
    0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0xdd, 0x77, 
    0xdd, 0x77, 0xdd, 0x77, 0xdd, 0x77, 0xdd, 0x77, 
    0xdd, 0x77, 0xdd, 0x77, 0x18, 0x18, 0x18, 0x18, 
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 
    0x18, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 
    0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0x18, 0xf8, 
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x36, 0x36, 
    0x36, 0x36, 0x36, 0x36, 0x36, 0xf6, 0x36, 0x36, 
    0x36, 0x36, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xfe, 0x36, 0x36, 0x36, 0x36, 
    0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 
    0x18, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 
    0x36, 0x36, 0x36, 0x36, 0x36, 0xf6, 0x06, 0xf6, 
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 
    0x36, 0x36, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0xfe, 0x06, 0xf6, 0x36, 0x36, 0x36, 0x36, 
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0xf6, 
    0x06, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0xfe, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 
    0x18, 0x18, 0x18, 0xf8, 0x18, 0xf8, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xf8, 0x18, 0x18, 0x18, 0x18, 
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 
    0x18, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x18, 0x18, 
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 
    0x18, 0x18, 0x18, 0x1f, 0x18, 0x18, 0x18, 0x18, 
    0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 
    0x18, 0x18, 0x18, 0x1f, 0x18, 0x1f, 0x18, 0x18, 
    0x18, 0x18, 0x18, 0x18, 0x36, 0x36, 0x36, 0x36, 
    0x36, 0x36, 0x36, 0x37, 0x36, 0x36, 0x36, 0x36, 
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x37, 
    0x30, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x30, 0x37, 
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 
    0x36, 0x36, 0x36, 0xf7, 0x00, 0xff, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0xff, 0x00, 0xf7, 0x36, 0x36, 0x36, 0x36, 
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x37, 
    0x30, 0x37, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 
    0x36, 0x36, 0x36, 0xf7, 0x00, 0xf7, 0x36, 0x36, 
    0x36, 0x36, 0x36, 0x36, 0x18, 0x18, 0x18, 0x18, 
    0x18, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 
    0x36, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x36, 0x36, 
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 
    0x36, 0x36, 0x36, 0x3f, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 
    0x18, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x18, 0x1f, 
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x36, 0x36, 
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 
    0x36, 0x36, 0x36, 0xff, 0x36, 0x36, 0x36, 0x36, 
    0x36, 0x36, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 
    0x18, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x18, 0x18, 
    0x18, 0x18, 0x18, 0x18, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0x0f, 0x0f, 
    0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 
    0x0f, 0x0f, 0x0f, 0x0f, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xdc, 
    0xd8, 0xd8, 0xd8, 0xdc, 0x76, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x78, 0xcc, 0xd8, 0xfc, 
    0xc6, 0xe6, 0xdc, 0xc0, 0xc0, 0x00, 0x00, 0x00, 
    0xfe, 0x66, 0x62, 0x60, 0x60, 0x60, 0x60, 0x60, 
    0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0xfe, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xfe, 0xc6, 0x62, 0x30, 
    0x18, 0x30, 0x62, 0xc6, 0xfe, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xd8, 0xcc, 
    0xcc, 0xcc, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x7c, 0x60, 
    0xc0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x76, 0xdc, 0x18, 0x18, 0x18, 0x18, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xfe, 0x38, 0x6c, 0xc6, 
    0xc6, 0xc6, 0x6c, 0x38, 0xfe, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x38, 0x6c, 0xc6, 0xc6, 0xfe, 0xc6, 
    0xc6, 0x6c, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x38, 0x6c, 0xc6, 0xc6, 0xc6, 0x6c, 0x6c, 0x6c, 
    0xee, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x60, 
    0x30, 0x3c, 0x66, 0xc6, 0xc6, 0xcc, 0x78, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 
    0xdb, 0xdb, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x06, 0x0c, 0x7c, 0xde, 0xf6, 0xe6, 
    0x7c, 0x60, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x1c, 0x30, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x30, 
    0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 
    0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 
    0x00, 0xfe, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x7e, 0x18, 
    0x18, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x30, 0x18, 0x0c, 0x06, 0x0c, 0x18, 0x30, 0x00, 
    0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x18, 
    0x30, 0x60, 0x30, 0x18, 0x0c, 0x00, 0x7e, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x1e, 0x1a, 
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 
    0x18, 0x58, 0x78, 0x30, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x18, 0x18, 0x00, 0x7e, 0x00, 0x18, 0x18, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x76, 0xdc, 0x00, 0x76, 0xdc, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x78, 0xcc, 0xcc, 0x78, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 
    0x18, 0x18, 0x18, 0x18, 0xd8, 0x78, 0x38, 0x18, 
    0x00, 0x00, 0x00, 0xd8, 0x6c, 0x6c, 0x6c, 0x6c, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x70, 0xd8, 0x30, 0x60, 0xf8, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x06, 0x3c, 
    0x6e, 0x6e, 0x76, 0x76, 0x3c, 0x60, 0x40, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x06, 0x7e, 0xce, 0xde, 
    0xde, 0xf6, 0xf6, 0xe6, 0xfc, 0xc0, 0x00, 0x00, 
};

//
// Static PGL font structure for 8x14 font
//
PGL_font pgl_fixedfont8x14[] =
{
    8,  // character width
    14, // character height
    {   // character index array

        0x0000, 0x000e, 0x001c, 0x002a, 0x0038, 0x0046, 0x0054, 0x0062,
        0x0070, 0x007e, 0x008c, 0x009a, 0x00a8, 0x00b6, 0x00c4, 0x00d2, 
        0x00e0, 0x00ee, 0x00fc, 0x010a, 0x0118, 0x0126, 0x0134, 0x0142, 
        0x0150, 0x015e, 0x016c, 0x017a, 0x0188, 0x0196, 0x01a4, 0x01b2, 
        0x0000, 0x01c0, 0x01ce, 0x01dc, 0x01ea, 0x01f8, 0x0206, 0x0214, 
        0x0222, 0x0230, 0x023e, 0x024c, 0x025a, 0x0268, 0x0276, 0x0284, 
        0x0292, 0x02a0, 0x02ae, 0x02bc, 0x02ca, 0x02d8, 0x02e6, 0x02f4, 
        0x0302, 0x0310, 0x031e, 0x032c, 0x033a, 0x0348, 0x0356, 0x0364, 
        0x0372, 0x0380, 0x038e, 0x039c, 0x03aa, 0x03b8, 0x03c6, 0x03d4, 
        0x03e2, 0x03f0, 0x03fe, 0x040c, 0x041a, 0x0428, 0x0436, 0x0444, 
        0x0452, 0x0460, 0x046e, 0x047c, 0x048a, 0x0498, 0x04a6, 0x04b4, 
        0x04c2, 0x04d0, 0x04de, 0x04ec, 0x04fa, 0x0508, 0x0516, 0x0524, 
        0x0532, 0x0540, 0x054e, 0x055c, 0x056a, 0x0578, 0x0586, 0x0594, 
        0x05a2, 0x05b0, 0x05be, 0x05cc, 0x05da, 0x05e8, 0x05f6, 0x0604, 
        0x0612, 0x0620, 0x062e, 0x063c, 0x064a, 0x0658, 0x0666, 0x0674, 
        0x0682, 0x0690, 0x069e, 0x06ac, 0x06ba, 0x06c8, 0x06d6, 0x06e4, 
        0x06f2, 0x0700, 0x070e, 0x071c, 0x072a, 0x0738, 0x0746, 0x0754, 
        0x0762, 0x0770, 0x077e, 0x078c, 0x079a, 0x07a8, 0x07b6, 0x07c4, 
        0x07d2, 0x07e0, 0x07ee, 0x07fc, 0x080a, 0x0818, 0x0826, 0x0834, 
        0x0842, 0x0850, 0x085e, 0x086c, 0x087a, 0x0888, 0x0896, 0x08a4, 
        0x08b2, 0x08c0, 0x08ce, 0x08dc, 0x08ea, 0x08f8, 0x0906, 0x0914, 
        0x0922, 0x0930, 0x093e, 0x094c, 0x095a, 0x0968, 0x0976, 0x0984, 
        0x0992, 0x09a0, 0x09ae, 0x09bc, 0x09ca, 0x09d8, 0x09e6, 0x09f4, 
        0x0a02, 0x0a10, 0x0a1e, 0x0a2c, 0x0a3a, 0x0a48, 0x0a56, 0x0a64, 
        0x0a72, 0x0a80, 0x0a8e, 0x0a9c, 0x0aaa, 0x0ab8, 0x0ac6, 0x0ad4, 
        0x0ae2, 0x0af0, 0x0afe, 0x0b0c, 0x0b1a, 0x0b28, 0x0b36, 0x0b44, 
        0x0b52, 0x0b60, 0x0b6e, 0x0b7c, 0x0b8a, 0x0b98, 0x0ba6, 0x0bb4, 
        0x0bc2, 0x0bd0, 0x0bde, 0x0bec, 0x0bfa, 0x0c08, 0x0c16, 0x0c24, 
        0x0c32, 0x0c40, 0x0c4e, 0x0c5c, 0x0c6a, 0x0c78, 0x0c86, 0x0c94, 
        0x0ca2, 0x0cb0, 0x0cbe, 0x0ccc, 0x0cda, 0x0ce8, 0x0cf6, 0x0d04, 
        0x0d12, 0x0d20, 0x0d2e, 0x0d3c, 0x0d4a, 0x0d58, 0x0d66, 0x0d74, 
        0x0d82, 0x0d90, 0x0d9e, 0x0dac, 0x0dba, 0x0dc8, 0x0dd6, 0x0000, 
    },
    pgl_fontbitmap8x14, // pointer to bitmap data array
    NULL                // reserved
};

/* --------------------------------------------------------------------------
  PGL_getfixedfont8x14 - returns a pointer to the PGL internal 8x14 font

  This function returns a "PGL_font" pointer to the PGL's internal 8x14 font
  structure. This function is useful if loading a font file is not desired as
  with PGL_loadfont(). It is also always available. It should be noted that
  using this function will add the static font structure to the size of the
  application. Since this function returns a pointer instead of filling a
  given PGL_font structure, the application must access the font structure
  elements using '->' (instead of '.' as with PGL_loadfont()).
-------------------------------------------------------------------------- */
PGL_font *PGL_getfixedfont8x14(void)
{
    return (pgl_fixedfont8x14);
}

